import { world, EquipmentSlot, GameMode, Player, BlockPermutation } from "@minecraft/server";

function applyDurabilityDamage(source, mainhand) {
    if (source.getGameMode() === GameMode.creative) return; // Skip durability damage in creative mode

    const itemStack = mainhand.getItem();
    if (!itemStack) return;

    const durability = itemStack.getComponent("minecraft:durability");
    if (!durability) return;

    // Factor in unbreaking enchantment
    const enchantable = itemStack.getComponent("minecraft:able");
    const unbreakingLevel = enchantable?.getEnchantment("unbreaking")?.level ?? 0;

    const damageChance = durability.getDamageChance(unbreakingLevel) / 100;

    if (Math.random() > damageChance) return; // Randomly skip damage based on unbreaking level

    // Damage the item
    if (durability.damage >= durability.maxDurability - 1) {
        mainhand.setItem(undefined); // Remove the item when it breaks
        source.playSound("random.break"); // Play break sound
    } else {
        durability.damage++; // Increase durability damage
        mainhand.setItem(itemStack); // Update item in hand
    }
}

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('tool:can_be_damaged', {
        onMineBlock({ source }) {
            // Get main hand slot
            if (!(source instanceof Player)) return;
        
            const equippable = source.getComponent("minecraft:equippable");
            if (!equippable) return;
        
            const mainhand = equippable.getEquipmentSlot(EquipmentSlot.Mainhand);
            if (!mainhand.hasItem()) return;
        
            applyDurabilityDamage(source, mainhand);
        }
      });
      initEvent.itemComponentRegistry.registerCustomComponent('dmss:forest_axe',{
        onMineBlock({source}){
            const logBlocks = [
                "minecraft:oak_log",
                "minecraft:birch_log",
                "minecraft:spruce_log",
                "minecraft:jungle_log",
                "minecraft:acacia_log",
                "minecraft:dark_oak_log",
                "minecraft:mangrove_log"
            ];
            if (logBlocks.includes(block.typeId) && source.getComponent("minecraft:is_sleeping")?.value) {
            source.runCommandAsync("function forest_axe");
            }
        }
    });
});
